<?php
defined('PF_VERSION') OR exit('Access denied');
$current = isset($_GET['current']) ? $_GET['current'] : '';
?>
<div class="hidden" id="messageErrorJS">
    <ul>
        <li class="errorLengthNewURL"><?php echo __('Please enter at least 1 character', 'page'); ?></li>
        <li class="existsURL"><?php echo __('URL already exists. Please use other url', 'page'); ?></li>
        <li class="urlNotEmpty"><?php echo __('URL should not be empty', 'page'); ?></li>
    </ul>
</div>
<div class="row pull-right btnTop">
    <div class="col-md-12">
        <?php
        add_toolbar_button(form_button("<i class='fa fa-check'></i> " . __('Save', 'page'), array('class' => 'btn btn-primary btnSave')));
        add_toolbar_button(form_button(" " . __('Cancel', 'page'), array('onclick' => "window.location='" . admin_url(array('admin-page' => 'page', 'current' => $current), false) . "'", 'class' => 'btn btn-default')));
        ?>
    </div>
</div><!--end button-->
<form action="<?php echo admin_url('&act=edit') ?>" class="form-horizontal" method="post" role="form">
    <div class="box box-primary">
        <div class="box-body cu">
            <?php require_once ABSPATH . '/includes/common/plugin/views/alert.php'; ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group titleWrap <?php echo state_validator('title', $validated); ?>">
                        <label for="title" class="col-sm-1 control-label"><?php echo __('Title', 'page'); ?> <span>*</span></label>
                        <div class="col-sm-11">
                            <?php
                            echo form_input(array('name' => 'title', 'class' => 'form-control', 'id' => 'title', 'tabindex' => 1, 'value' => $page->page_title));
                            echo alert_error_validator('title', $validated);
                            echo form_input(array('name' => 'page_id', 'type' => 'hidden', 'value' => $page->id));
                            echo form_input(array('name' => 'current', 'type' => 'hidden', 'value' => $current));
                            ?>
                        </div>                        
                    </div>
                    <div class="form-group permalinkWrap" data-method="edit">
                        <label for="permalink" class="col-sm-1 control-label"></label>
                        <div class="col-md-11 col-md-offset-1">
                            <div class="defaultURL pull-left">
                                <strong><?php echo __('URL', 'page'); ?>:</strong> 
                                <span><?php echo site_url() . RELATIVE_PATH . '/'; ?></span>
                            </div>
                            <div class="customSlug pull-left">
                                <div class=" pull-left editPageName" id="editPageName">
                                </div>
                                <div class="groupAction pull-left">
                                    <button class="btn btn-xs btn-warning" type="button" name="edit"><?php echo __('Edit URL', 'page'); ?></button>
                                    <button class="btn btn-xs btn-primary" type="button" name="save"><?php echo __('Save', 'page'); ?></button>
                                    <button class="btn btn-xs btn-default" type="button" name="cancel"><?php echo __('Cancel', 'page'); ?></button>
                                </div>
                            </div>
                        </div>
                        <?php
                        echo form_input(array('name' => 'url', 'type' => 'hidden', 'id' => 'slug', 'value' => $page->page_url));
                        ?>
                    </div>
                </div>
            </div><!--end title-->
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group <?php echo state_validator('layout', $validated); ?>">
                        <label for="layout" class="col-sm-2 control-label"><?php echo __('Layout', 'page'); ?> <span>*</span></label>
                        <div class="col-sm-10">
                            <?php
                            echo form_dropdown('layout', $layouts, $page->page_layout, "class='form-control' tabindex='2'");
                            echo alert_error_validator('layout', $validated);
                            ?>
                        </div>
                    </div>
                    <div class="form-group <?php echo state_validator('status', $validated); ?>">
                        <label for="status" class="col-sm-2 control-label"><?php echo __('Status', 'page'); ?></label>
                        <div class="col-sm-10">
                            <?php
                            echo form_dropdown('status', $status, $page->page_status, "class='form-control' tabindex='3'");
                            echo alert_error_validator('status', $validated);
                            ?>
                        </div>
                    </div>

                    <div class="form-group <?php echo state_validator('type', $validated); ?>">
                        <label for="page_type" class="col-sm-2 control-label"><?php echo __('Page Type', 'page'); ?></label>
                        <div class="col-sm-10">
                            <?php
                            echo form_dropdown('type', $page_type, $page->page_type, "class='form-control' tabindex='5'");
                            echo alert_error_validator('type', $validated);
                            ?>
                        </div>
                    </div>

                </div>
                <div class="col-md-6">
                    <div class="form-group <?php echo state_validator('meta_title', $validated); ?>">
                        <label for="title" class="col-sm-2 control-label"><?php echo __('Meta title', 'page'); ?></label>
                        <div class="col-sm-10">
                            <?php
                            echo form_input(array('name' => 'meta_title', 'class' => 'form-control', 'tabindex' => 7, 'value' => $page->page_meta_title));
                            echo alert_error_validator('meta_title', $validated);
                            ?>
                        </div>
                    </div>
                    <div class="form-group <?php echo state_validator('meta_keywords', $validated); ?>">
                        <label for="title" class="col-sm-2 control-label"><?php echo __('Meta keywords', 'page'); ?></label>
                        <div class="col-sm-10">
                            <?php
                            echo form_input(array('name' => 'meta_keywords', 'class' => 'form-control', 'tabindex' => 8, 'value' => $page->page_meta_keywords));
                            echo alert_error_validator('meta_keywords', $validated);
                            ?>
                        </div>
                    </div>
                    <div class="form-group <?php echo state_validator('meta_description', $validated); ?>">
                        <label for="title" class="col-sm-2 control-label"><?php echo __('Meta description', 'page'); ?></label>
                        <div class="col-sm-10">
                            <?php
                            echo form_textarea(array('name' => 'meta_description', 'class' => 'form-control', 'rows' => 2, 'tabindex' => 9), $page->page_meta_description);
                            echo alert_error_validator('meta_description', $validated);
                            ?>
                        </div>
                    </div>
                </div>
            </div><!--end control-->
            <div class="row">
                <div class="col-md-12">
                    <div class="form-group <?php echo state_validator('content', $validated); ?>">
                        <label for="Content" class="col-sm-1 control-label"><?php echo __('Content', 'page'); ?> <span>*</span></label>
                        <div class="col-sm-11">
                            <?php
                            echo form_editor(array('name' => 'content', 'style' => 'height: 500px;', 'tabindex' => 6), $page->page_content);
                            echo alert_error_validator('content', $validated);
                            ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--end button-->
</form>
<div class="controlClone hidden">
    <input type="text" class="form-control input-sm" id="tempInput" />
</div>